package com.xebialabs.deployit.plugin.tomcat.ci;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.MiddlewareResource;

import java.util.List;
import java.util.Map;

/**
 * A Set of Global JNDI Resources
 */
@SuppressWarnings("serial")
@ConfigurationItem
public class TomcatJNDIResources extends BaseConfigurationItem implements MiddlewareResource {

	@ConfigurationItemProperty(description = "Resources links that are to stored in the Tomcat JNDI tree")
	private List<ResourceLink> resourceLinks = Lists.newArrayList();

	public List<ResourceLink> getResourceLinks() {
		return resourceLinks;
	}

	public Map<String,ResourceLinkValue> getResourceLinksAsMap() {
		return ResourceLink.toMap(resourceLinks);
	}

	public void setResourceLinks(List<ResourceLink> resourceLinks) {
		this.resourceLinks = resourceLinks;
	}

	public void addResourceLink(ResourceLink link) {
		if (resourceLinks == null) {
			resourceLinks = Lists.newArrayList();
		}
		resourceLinks.add(link);
	}
}
