/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.tomcat.step;

import org.apache.commons.lang.StringUtils;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatWarMapping;

@SuppressWarnings("serial")
public abstract class TomcatStepBase implements Step {

	protected static final String STEP_RESOURCES_PATH = "com/xebialabs/deployit/plugin/tomcat/step/";

	protected String description;

	protected TomcatServer server;

	protected String contextRoot;

	protected TomcatWarMapping mapping;

	protected TomcatStepBase(TomcatServer server, TomcatWarMapping mapping) {
		this.server = server;
		this.mapping = mapping;
		this.contextRoot = mapping.getContextRoot();
	}

	protected TomcatStepBase(TomcatServer server) {
		this.server = server;
	}

	public String getDescription() {
		return description;
	}

	protected void setDescription(String description) {
		this.description = description;
	}

	public String getContextFilePathOnServer() {
		assert isContextSet() : "No context is set";
		return server.getContextWithoutVirtualHostDirPath() + server.getHost().getFileSeparator() + contextRoot + ".xml";
	}

	protected boolean isContextSet() {
		return !StringUtils.isBlank(mapping.getContextRoot());
	}

	
}
