/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat;

import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.plugin.tomcat.ci.ResourceLink;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatActiveMQConnectionFactory;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatDataSource;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatResource;
import com.xebialabs.deployit.plugin.tomcat.utils.CiToXML;
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatContextFileUtils {
    private HostFile contextFile;

    public TomcatContextFileUtils(HostFile contextFile) {
        this.contextFile = contextFile;
    }

    public boolean exists() {
        return this.contextFile.exists();
    }

    public boolean delete() {
        return this.contextFile.delete();
    }

    public void addOrUpdateContextPath(String docBase) {
        Document doc = this.getDocument();
        this.findAndRemoveExistingDocBase(doc);
        Element contextElement = this.getOrCreateContext(doc);
        contextElement.addAttribute("docBase", docBase);
        this.saveDocumentInContextFile(doc);
    }

    public void addOrUpdateDataSource(TomcatDataSource ds) {
        Document doc = this.getDocument();
        this.findAndRemoveExistingDatasource(ds, doc);
        Element context = this.getOrCreateContext(doc);
        Element newResourceDSElement = context.addElement("Resource");
        CiToXML<TomcatDataSource> toXml = new CiToXML<TomcatDataSource>(ds, newResourceDSElement);
        toXml.addTranslation("jndiName", "name");
        toXml.addTranslation("connectionUrl", "url");
        toXml.addTranslation("driverClass", "driverClassName");
        toXml.addAttribute("auth", "Container");
        toXml.addAttribute("type", "javax.sql.DataSource");
        toXml.process();
        this.saveDocumentInContextFile(doc);
    }

    public void addOrUpdateTomcatActiveMQConnectionFactory(TomcatActiveMQConnectionFactory amqcf) {
        Document doc = this.getDocument();
        this.findAndRemoveExistingAMQCF(amqcf, doc);
        Element context = this.getOrCreateContext(doc);
        Element newResourceDSElement = context.addElement("Resource");
        newResourceDSElement.addAttribute("name", amqcf.getJndiName());
        newResourceDSElement.addAttribute("auth", "Container");
        newResourceDSElement.addAttribute("type", "org.apache.activemq.ActiveMQConnectionFactory");
        newResourceDSElement.addAttribute("factory", amqcf.getFactory());
        newResourceDSElement.addAttribute("brokerName", amqcf.getBrokerName());
        newResourceDSElement.addAttribute("brokerURL", amqcf.getBrokerURL());
        this.saveDocumentInContextFile(doc);
    }

    public void addOrUpdateResources(List<ResourceLink> resources) {
        Document doc = this.getDocument();
        for (ResourceLink r : resources) {
            this.findAndRemoveExistingResourceLink(r, doc);
            Element context = this.getOrCreateContext(doc);
            Element newResourceDSElement = context.addElement("ResourceLink");
            CiToXML<ResourceLink> toXml = new CiToXML<ResourceLink>(r, newResourceDSElement);
            toXml.addAttribute("type", "java.lang." + (Object)((Object)r.getType()));
            toXml.process();
        }
        this.saveDocumentInContextFile(doc);
    }

    public void deleteResources(List<ResourceLink> resources) {
        Document doc = this.getDocument();
        for (ResourceLink r : resources) {
            this.findAndRemoveExistingResourceLink(r, doc);
        }
        this.saveDocumentInContextFile(doc);
    }

    private void findAndRemoveExistingResourceLink(ResourceLink r, Document doc) {
        List resourceTypeList = doc.selectNodes(String.format("//Context/ResourceLink[@name='%s']", r.getName()));
        for (Node n : resourceTypeList) {
            n.detach();
        }
    }

    public boolean deleteDataSource(TomcatDataSource ds) {
        Document doc = this.getDocument();
        this.findAndRemoveExistingDatasource(ds, doc);
        this.saveDocumentInContextFile(doc);
        return true;
    }

    public boolean deleteTomcatActiveMQConnectionFactory(TomcatActiveMQConnectionFactory amqcf) {
        Document doc = this.getDocument();
        this.findAndRemoveExistingAMQCF(amqcf, doc);
        this.saveDocumentInContextFile(doc);
        return true;
    }

    private void findAndRemoveExistingAMQCF(TomcatActiveMQConnectionFactory amqcf, Document doc) {
        this.findAndRemoveExistingTomcatResource(amqcf, doc, "org.apache.activemq.ActiveMQConnectionFactory");
    }

    private void findAndRemoveExistingDatasource(TomcatDataSource ds, Document doc) {
        this.findAndRemoveExistingTomcatResource(ds, doc, "javax.sql.DataSource");
    }

    private Document getDocument() {
        Document doc;
        if (this.contextFile.exists()) {
            SAXReader reader = new SAXReader();
            try {
                doc = reader.read(this.contextFile.get());
            }
            catch (RuntimeIOException e) {
                throw new RuntimeIOException("Unable to parse existing context xml file " + this.contextFile.getName(), (Throwable)e);
            }
            catch (DocumentException e) {
                throw new RuntimeIOException("Unable to parse existing context xml file " + this.contextFile.getName(), (Throwable)e);
            }
        } else {
            doc = DocumentHelper.createDocument();
            HostFile parentFile = this.contextFile.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
        }
        return doc;
    }

    private void findAndRemoveExistingTomcatResource(TomcatResource tomcatResource, Document doc, String resourceType) {
        List resourceTypeList = doc.selectNodes("//Context/Resource/@type");
        for (Attribute type : resourceTypeList) {
            Element resource;
            Attribute name;
            String nameValue;
            String value = type.getValue();
            if (!value.equalsIgnoreCase(resourceType) || !(nameValue = (name = (Attribute)(resource = type.getParent()).selectSingleNode("@name")).getValue()).equals(tomcatResource.getJndiName())) continue;
            Element parent = resource.getParent();
            parent.remove(resource);
        }
    }

    private void findAndRemoveExistingDocBase(Document doc) {
        Attribute docBaseAttr = (Attribute)doc.selectSingleNode("//Context/@docBase");
        if (docBaseAttr != null) {
            docBaseAttr.getParent().remove(docBaseAttr);
        }
    }

    private void saveDocumentInContextFile(Document doc) {
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter(stringWriter);
        try {
            xmlWriter.write(doc);
            xmlWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException("Unable to add or update Tomcat context xml file " + this.contextFile.getName(), (Throwable)e);
        }
        HostFileUtils.putStringToHostFile((String)stringWriter.toString(), (HostFile)this.contextFile);
    }

    private Element getOrCreateContext(Document doc) {
        Element contextElement = doc.selectSingleNode("//Context") == null ? doc.addElement("Context") : (Element)doc.selectSingleNode("Context");
        return contextElement;
    }
}

