/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatResource;

@ConfigurationItem
public class TomcatDataSource
extends TomcatResource {
    public static final String TYPE = "javax.sql.DataSource";
    @ConfigurationItemProperty(description="The fully qualified Java class name of the JDBC driver to be used")
    private String driverClass;
    @ConfigurationItemProperty(description="The connection URL to be passed to our JDBC driver to establish a connection", size=ConfigurationItemProperty.Size.LARGE)
    private String connectionUrl;
    @ConfigurationItemProperty(description="The connection username to be passed to our JDBC driver to establish a connection")
    private String username;
    @ConfigurationItemProperty(password=true, description="The connection password to be passed to our JDBC driver to establish a connection")
    private String password;
    @ConfigurationItemProperty(description="The connection properties that will be sent to our JDBC driver when establishing new connections")
    private String connectionProperties;
    @ConfigurationItemProperty(description="The default auto-commit state of connections created by this pool, default value is true")
    private boolean defaultAutoCommit;
    @ConfigurationItemProperty(description="The default read-only state of connections created by this pool, default value is driver default")
    private String defaultReadOnly;
    @ConfigurationItemProperty(description="The default catalog of connections created by this pool")
    private String defaultCatalog;
    @ConfigurationItemProperty(description="The initial number of connections that are created when the pool is started, default value is 0")
    private int initialSize = 0;
    @ConfigurationItemProperty(description="The maximum number of active connections that can be allocated from this pool at the same time, or negative for no limit, default value is 8")
    private int maxActive = 8;
    @ConfigurationItemProperty(description="The maximum number of connections that can remain idle in the pool, without extra ones being released, or negative for no limit, default value is 8")
    private int maxIdle = 8;
    @ConfigurationItemProperty(description="The minimum number of connections that can remain idle in the pool, without extra ones being created, or zero to create none, default value is 0")
    private int minIdle = 0;
    @ConfigurationItemProperty(description="The maximum number of milliseconds that the pool will wait (when thereare no available connections) for a connection to be returned before throwing an exception, or -1 to wait indefinitely, default value is indefinitely")
    private int maxWait = -1;
    @ConfigurationItemProperty(description="The SQL query that will be used to validate connections from this pool before returning them to the caller")
    private String validationQuery;
    @ConfigurationItemProperty(description="The indication of whether objects will be validated before being borrowed from the pool, default value is true")
    private boolean testOnBorrow = true;
    @ConfigurationItemProperty(description="The indication of whether objects will be validated before being returned to the pool, default value is false")
    private boolean testOnReturn = false;
    @ConfigurationItemProperty(description="The indication of whether objects will be validated by the idle object  evictor (if any), default value is false")
    private boolean testWhileIdle = false;
    @ConfigurationItemProperty(description="The number of milliseconds to sleep between runs of the idle object evictor thread, default value is -1")
    private int timeBetweenEvictionRunsMillis = -1;
    @ConfigurationItemProperty(description="The number of objects to examine during each run of the idle object evictor thread (if any), default value is 3")
    private int numTestsPerEvictionRun = 3;
    @ConfigurationItemProperty(description="The minimum amount of time an object may sit idle in the pool before it is eligable for eviction by the idle object evictor (if any), default value is 1000 * 60 * 30")
    private int minEvictableIdleTimeMillis = 1800000;
    @ConfigurationItemProperty(description="A Collection of SQL statements that will be used to initialize physical connections when they are first created, default value is null")
    private String connectionInitSqls;
    @ConfigurationItemProperty(description="Enable prepared statement pooling for this pool, default value is false")
    private boolean poolPreparedStatements = false;
    @ConfigurationItemProperty(description="The maximum number of open statements that can be allocated from  the statement pool at the same time, or zero for no limit, default value is unlimited")
    private int maxOpenPreparedStatements = -1;
    @ConfigurationItemProperty(description="Controls if the PoolGuard allows access to the underlying connection, default value is false")
    private boolean accessToUnderlyingConnectionAllowed = false;
    @ConfigurationItemProperty(description="Flag to remove abandoned connections if they exceed the removeAbandonedTimout, default value is false")
    private boolean removeAbandoned = false;
    @ConfigurationItemProperty(description="Timeout in seconds before an abandoned connection can be removed, default value is 300")
    private int removeAbandonedTimeout = 300;
    @ConfigurationItemProperty(description="Flag to log stack traces for application code which abandoned a Statement or Connection, default value is false")
    private boolean logAbandoned = false;

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConnectionProperties() {
        return this.connectionProperties;
    }

    public void setConnectionProperties(String connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    public boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    public String getDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(String defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly;
    }

    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.defaultCatalog = defaultCatalog;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public int getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(int maxWait) {
        this.maxWait = maxWait;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public boolean isTestOnReturn() {
        return this.testOnReturn;
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    public int getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(int timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public int getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public void setMinEvictableIdleTimeMillis(int minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public String getConnectionInitSqls() {
        return this.connectionInitSqls;
    }

    public void setConnectionInitSqls(String connectionInitSqls) {
        this.connectionInitSqls = connectionInitSqls;
    }

    public boolean isPoolPreparedStatements() {
        return this.poolPreparedStatements;
    }

    public void setPoolPreparedStatements(boolean poolPreparedStatements) {
        this.poolPreparedStatements = poolPreparedStatements;
    }

    public int getMaxOpenPreparedStatements() {
        return this.maxOpenPreparedStatements;
    }

    public void setMaxOpenPreparedStatements(int maxOpenPreparedStatements) {
        this.maxOpenPreparedStatements = maxOpenPreparedStatements;
    }

    public boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    public void setAccessToUnderlyingConnectionAllowed(boolean accessToUnderlyingConnectionAllowed) {
        this.accessToUnderlyingConnectionAllowed = accessToUnderlyingConnectionAllowed;
    }

    public boolean isRemoveAbandoned() {
        return this.removeAbandoned;
    }

    public void setRemoveAbandoned(boolean removeAbandoned) {
        this.removeAbandoned = removeAbandoned;
    }

    public int getRemoveAbandonedTimeout() {
        return this.removeAbandonedTimeout;
    }

    public void setRemoveAbandonedTimeout(int removeAbandonedTimeout) {
        this.removeAbandonedTimeout = removeAbandonedTimeout;
    }

    public boolean isLogAbandoned() {
        return this.logAbandoned;
    }

    public void setLogAbandoned(boolean logAbandoned) {
        this.logAbandoned = logAbandoned;
    }
}

