/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.ci;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.mapping.Mapping;
import com.xebialabs.deployit.plugin.tomcat.ci.ResourceLink;
import com.xebialabs.deployit.plugin.tomcat.ci.ResourceLinkValue;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatJNDIResources;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatUnmanagedServer;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfigurationItem
public class TomcatJNDIResourcesMapping
extends Mapping<TomcatJNDIResources, TomcatUnmanagedServer> {
    @ConfigurationItemProperty(description="Resources links that are to stored in the Tomcat JNDI tree")
    private List<ResourceLink> resourceLinks = Lists.newArrayList();

    public TomcatJNDIResourcesMapping() {
    }

    public TomcatJNDIResourcesMapping(TomcatJNDIResources jndiProperties, TomcatUnmanagedServer server) {
        super((Serializable)((Object)jndiProperties), (Serializable)((Object)server));
    }

    public List<ResourceLink> getResourceLinks() {
        return this.resourceLinks;
    }

    public Map<String, ResourceLinkValue> getResourceLinksAsMap() {
        return ResourceLink.toMap(this.resourceLinks);
    }

    public void setResourceLinks(List<ResourceLink> resourceLinks) {
        this.resourceLinks = resourceLinks;
    }

    public void addResourceLink(ResourceLink link) {
        if (this.resourceLinks == null) {
            this.resourceLinks = Lists.newArrayList();
        }
        this.resourceLinks.add(link);
    }
}

