/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.tomcat.TomcatContextFileUtils;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatActiveMQConnectionFactory;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatUnmanagedServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatWarMapping;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatStepBase;

public class DestroyTomcatActiveMQConnectionFactoryStep
extends TomcatStepBase
implements Step {
    private TomcatActiveMQConnectionFactory amqcf;

    public DestroyTomcatActiveMQConnectionFactoryStep(TomcatUnmanagedServer server, TomcatActiveMQConnectionFactory amqcf, TomcatWarMapping mapping) {
        super(server, mapping);
        this.amqcf = amqcf;
        this.setDescription("Destroy AMQ Connection Factory " + (Object)((Object)amqcf) + " on Tomcat server " + (Object)((Object)server));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession hostSession = this.server.getHost().getHostSession();
        try {
            HostFile contextFile = hostSession.getFile(this.getContextFilePathOnServer());
            ctx.logOutput("deleting AMQ Connection Factory " + (Object)((Object)this.amqcf) + " definition from the context file " + contextFile.getPath());
            TomcatContextFileUtils contextFileUtils = new TomcatContextFileUtils(contextFile);
            boolean deletionResult = contextFileUtils.deleteTomcatActiveMQConnectionFactory(this.amqcf);
            ctx.logOutput("Done.");
            boolean bl = deletionResult;
            return bl;
        }
        finally {
            hostSession.close();
        }
    }
}

