/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm;

import java.util.HashSet;
import java.util.Set;

import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

@PublicApiRef
public abstract class AbstractDictionary extends BaseConfigurationItem implements IDictionary {

    @Property(required = false, label = "Restrict to containers", description = "Only apply this dictionary to the containers mentioned", category = "Restrictions")
    private Set<Container> restrictToContainers = new HashSet<>();

    @Property(required = false, label = "Restrict to applications", description = "Only apply this dictionary to the applications mentioned", category = "Restrictions")
    private Set<Application> restrictToApplications = new HashSet<>();

    /**
     * @return The set of {@link Container}s only for which the dictionary is applied.
     */
    public Set<Container> getRestrictToContainers() {
        return restrictToContainers;
    }

    /**
     * @return The set of {@link Application}s only for which the dictionary is applied.
     */
    public Set<Application> getRestrictToApplications() {
        return restrictToApplications;
    }

    @Override
    public IDictionary applyTo(final DictionaryContext context) {
        boolean appMatches = this.getRestrictToApplications().isEmpty() || this.getRestrictToApplications().contains(context.getApplication());
        boolean containerMatches = this.getRestrictToContainers().isEmpty() || this.getRestrictToContainers().contains(context.getContainer());

        if (appMatches && containerMatches) return this;
        return null;
    }
}
