/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.deployment.planning;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;

import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Annotates methods that contribute to a deployment plan. 
 * 
 * <p>
 * The annotated method should take the following parameters:
 * <ul>
 *     <li>{@link Deltas} The collection of Deltas that are currently being planned.</li>
 *     <li>{@link DeploymentPlanningContext} The Planning Context</li>
 * </ul>
 * The annotated method should not have a return type (void).
 * 
 * The class containing the method must have a no-arg constructor.
 */
@Retention(RUNTIME)
@Target(ElementType.METHOD)
public @interface Contributor {
}
