/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm.base;

import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.validation.FileEncodings;
import com.xebialabs.deployit.plugin.api.validation.Regex;
import com.xebialabs.deployit.plugin.credentials.Credentials;
import com.xebialabs.deployit.plugin.proxy.ProxySettings;
import com.xebialabs.overthere.OverthereFile;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

@SuppressWarnings("serial")
@Metadata(virtual = true, description = "The supertype of all DeployableArtifacts.")
public class BaseDeployableArtifact extends BaseDeployable implements DeployableArtifact {

    public static final String SCAN_PLACEHOLDERS_PROPERTY_NAME = "scanPlaceholders";

    private OverthereFile file;

    @Property(required = false, label = "Replace Placeholders", category = "Placeholders", description = "Whether to scan this artifact to replace placeholders when it is imported", defaultValue = "true")
    private boolean scanPlaceholders;

    @Property(required = false, label = "Pre-Scanned Placeholders", category = "Placeholders", description = "Whether this artifact has been pre-scanned by the packager (ie. scanned for placeholders and checksum is set)", defaultValue = "false")
    private boolean preScannedPlaceholders;

    @Property(required = false, category = "Placeholders", description = "Placeholders detected in this artifact")
    private Set<String> placeholders = new TreeSet<>();

    @Property(required = false, category = "Placeholders", description = "The delimiters used indicate placeholders, defaults to '{{ }}'. This is a 5 character string with a space in the middle, the first two are the leading delimiter, the last two are the closing delimiter",
            defaultValue = "{{ }}", hidden = true)
    @Regex(pattern = ".. ..")
    private String delimiters = "{{ }}";

    @Property(hidden = true, category = "Placeholders", description = "Regular expression that matches file names of text files", defaultValue =
            ".+\\.(" +
                    "cfg | conf | config | ini | properties | props | txt | " +
                    "asp | aspx | htm | html | jsf | jsp | xht | xhtml | " +
                    "sql | " +
                    "xml | xsd | xsl | xslt" +
                    ")")
    private String textFileNamesRegex;

    @Property(required = false, category = "Placeholders", description = "Regular expression that matches file names that must be excluded from scanning")
    private String excludeFileNamesRegex;

    @Property(required = false, category = "Deployment", description = "The checksum used to detect differences on the artifact. If not provided, it will be calculated by XL Deploy.")
    private String checksum;

    @Property(required = false, category = "Placeholders", description = "A map that maps regular expressions matching the full path of file(s) in the artifact to character set encodings",
            defaultValue = ".+\\.properties:ISO-8859-1")
    @FileEncodings
    private Map<String, String> fileEncodings;

    @Property(required = false, description = "The URI pointing to the (remote) location of the file this artifact represents")
    private String fileUri;

    @Property(required = false, description = "Credentials of the URI.")
    private Credentials credentials;

    @Property(required = false, description = "Proxy Settings for artifact location")
    private ProxySettings proxySettings;

    @Property(required = false, description = "Indicates if the artifact has been rescanned", defaultValue = "false")
    private boolean isRescanned;

    public Credentials getCredentials() {
        return credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    @Override
    public ProxySettings getProxySettings() {
        return proxySettings;
    }

    public void setProxySettings(ProxySettings proxySettings) {
        this.proxySettings = proxySettings;
    }

    public OverthereFile getFile() {
        return file;
    }

    public void setFile(OverthereFile file) {
        this.file = file;
    }

    public boolean isScanPlaceholders() {
        return scanPlaceholders;
    }

    public void setScanPlaceholders(boolean scanPlaceholders) {
        this.scanPlaceholders = scanPlaceholders;
    }

    public boolean isPreScannedPlaceholders() {
        return preScannedPlaceholders;
    }

    public void setPreScannedPlaceholders(boolean preScannedPlaceholders) {
        this.preScannedPlaceholders = preScannedPlaceholders;
    }

    public Set<String> getPlaceholders() {
        return placeholders;
    }

    public void setPlaceholders(Set<String> placeholders) {
        this.placeholders = placeholders;
    }

    public String getTextFileNamesRegex() {
        return textFileNamesRegex;
    }

    public void setTextFileNamesRegex(String textFileNamesRegex) {
        this.textFileNamesRegex = textFileNamesRegex;
    }

    @Override
    public String getExcludeFileNamesRegex() {
        return excludeFileNamesRegex;
    }

    @Override
    public Map<String, String> getFileEncodings() {
        return fileEncodings;
    }

    @Override
    public String getFileUri() {
        return fileUri;
    }

    public void setExcludeFileNamesRegex(String excludeFileNamesRegex) {
        this.excludeFileNamesRegex = excludeFileNamesRegex;
    }

    public String getChecksum() {
        return checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getDelimiters() {
        return delimiters;
    }

    public void setDelimiters(String delimiters) {
        this.delimiters = delimiters;
    }

    public boolean getRescanned() {
        return isRescanned;
    }

    public void setRescanned(boolean rescanned) {
        isRescanned = rescanned;
    }
}
