/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import java.util.Objects;

public class InputHintValue {
    private String value;
    private String label;

    private InputHintValue(final String value, final String label) {
        this.value = value;
        this.label = label;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        final InputHintValue that = (InputHintValue) o;
        return Objects.equals(value, that.value) &&
                Objects.equals(label, that.label);
    }

    @Override
    public String toString() {
        return "InputHintValue{" +
                "value='" + value + '\'' +
                ", label='" + label + '\'' +
                '}';
    }

    public String getValue() {
        return value;
    }

    public String getLabel() {
        return label;
    }

    public static InputHintValue inputHintValue(String value, String label) {
        return new InputHintValue(value, label);
    }
}
