/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm;

import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

import java.util.HashSet;
import java.util.Set;

@PublicApiRef
@Metadata(virtual = true, description = "Base type for all deployeds that are containers.")
public class BaseDeployedContainer<D extends Deployable, C extends Container> extends BaseDeployed<D, C> implements Container {

    @Property(required = false, category = "Deployment", description = "If set, only deployables with the same tag will be automatically mapped to this container.")
    private Set<String> tags = new HashSet<>();

    public BaseDeployedContainer() {
    }

    @Override
    public Set<String> getTags() {
        return tags;
    }

    @Override
    public void setTags(Set<String> tags) {
        this.tags = tags;
    }
}
