/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xlplatform.utils;

import java.util.List;

/**
 * String utilities
 */
public class Strings {
    /**
     * Make a string by joining them using the 'sep' string.
     * @param strings The strings to join.
     * @param sep The separator to use.
     * @return The joined string.
     */
    public static String mkString(List<String> strings, String sep) {
        if (strings.isEmpty()) return "";

        StringBuilder b = new StringBuilder();
        if (strings.get(0) != null) {
            b.append(strings.get(0));
        }
        for (int i = 1; i < strings.size(); i++) {
            if (strings.get(i) != null) {
                b.append(sep).append(strings.get(i));
            }
        }
        return b.toString();
    }

}
