/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm;

import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

/**
 * Base deployable for all provisioners. It is an embedded configuration item i.e it will always be
 * contained in another configuration item and can't be created as a top level deployable in a provisioning package.
 */
@PublicApiRef
@Metadata(virtual = true, description = "Base type for all provisioners.")
public class BaseProvisioner extends BaseConfigurationItem implements Provisioner {

    @Property(description = "Host template on which provisioning actions will be executed.", candidateValuesFilter = "filterProvisionerByProvisioningPackage")
    @TemplateHostValidator
    private Template hostTemplate = null;

    @Override
    public Template getHostTemplate() {
        return hostTemplate;
    }

    public void setHostTemplate(Template hostTemplate) {
        this.hostTemplate = hostTemplate;
    }
}
