/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.validation;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

import java.io.Serializable;

/**
 * A ValidationMessage may be returned for certain operations, related to specific property of a {@link com.xebialabs.deployit.plugin.api.udm.ConfigurationItem}.
 */
@PublicApiRef
public final class ValidationMessage implements Serializable {
    @PublicApiRef
    public enum Level { ERROR, WARNING, INFO }

    private final String ciId;
    private final String propertyName;
    private final String message;
    private final Level level;

    public ValidationMessage(String ciId, String propertyName, String message, String level) {
        this(ciId, propertyName, message, level == null ? null : Level.valueOf(level));
    }

    public ValidationMessage(String ciId, String propertyName, String message, Level level) {
        this.ciId = ciId;
        this.propertyName = propertyName;
        this.message = message;
        this.level = level == null ? Level.ERROR : level;
    }

    public ValidationMessage(String ciId, String propertyName, String message) {
        this(ciId, propertyName, message, (Level) null);
    }

    public static ValidationMessage error(String ciId, String propertyName, String message) {
        return new ValidationMessage(ciId, propertyName, message, Level.ERROR);
    }

    public static ValidationMessage warn(String ciId, String propertyName, String message) {
        return new ValidationMessage(ciId, propertyName, message, Level.WARNING);
    }

    public static ValidationMessage info(String ciId, String propertyName, String message) {
        return new ValidationMessage(ciId, propertyName, message, Level.INFO);
    }

    /**
     * @return The id of the {@link com.xebialabs.deployit.plugin.api.udm.ConfigurationItem}.
     */
    public String getCiId() {
        return ciId;
    }

    /**
     * @return The name of the property.
     */
    public String getPropertyName() {
        return propertyName;
    }

    /**
     * @return The validation message.
     */
    public String getMessage() {
        return message;
    }

    /**
     * @return The validation message level.
     */
    public Level getLevel() {
        return level;
    }

    @Override
    public String toString() {
        return "ValidationMessage[level=" + level + ", id=" + ciId + ", field=" + propertyName + ", message=" + message + "]";
    }
}
