/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm;

import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.APPLICATIONS;

/**
 * Conceptually, an Application is a configuration item (CI) representing a real-world application,
 * that can be deployed on a specific middleware.
 * <p>
 * Technically, an Application is a group of all the associated {@link Version}s. A Version (sometimes also called <i>package</i>)
 * can be either a {@link DeploymentPackage} or a {@link CompositePackage}, and contains a collection
 * of {@link DeployableArtifact}s and resource specifications. Such a package can be deployed on a {@link Container}.
 */
@SuppressWarnings("serial")
@Metadata(description = "An application. Each version of the application is a separate package.", root = APPLICATIONS)
@TypeIcon(value = "icons/types/udm.Application.svg")
@PublicApiRef
public class Application extends BaseConfigurationItem {

    @Property(hidden = false, required = false, defaultValue = "", category = "Deployment", description = "The latest application version number as the highest udm.Version name sorted in lexicographical ordering.")
    private String lastVersion = "";

    /**
     * @return The latest application version number as the highest udm.Version name sorted in lexicographical ordering.
     */
    public String getLastVersion() {
        return lastVersion;
    }

    /**
     * @param lastVersion The latest version number of the application.
     */
    public void setLastVersion(final String lastVersion) {
        this.lastVersion = lastVersion;
    }

}
