/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

import java.util.Set;

/**
 * Deployeds are configuration items (CIs) that represent {@link Deployable}s CIs in their deployed form on
 * the target {@link Container}.
 *
 * Deployeds go through the following life-cycle:
 * <ul>
 *     <li>The deployed is created on a target container for the first time in an initial deployment.</li>
 *     <li>The deployed is upgraded to a new version in an upgrade deployment.</li>
 *     <li>The deployed is removed from the target container when it is undeployed.</li>
 * </ul>
 *
 * @param <D> Something that is a {@link Deployable}
 * @param <C> Something that is a {@link Container}
 */
@PublicApiRef
@TypeIcon(value = "icons/types/udm.Deployed.svg")
public interface Deployed<D extends Deployable, C extends Container> extends EmbeddedDeployedContainer<D, C> {

    /**
     * Duplicated from {@link EmbeddedDeployedContainer} to retain binary compatibility.
     *
     * @return The associated {@link Deployable} CI.
     */
    D getDeployable();

    /**
     * Duplicated from {@link EmbeddedDeployedContainer} to retain binary compatibility.
     *
     * @param deployable The associated {@link Deployable} CI.
     */
    void setDeployable(D deployable);

    /**
     * Duplicated from {@link EmbeddedDeployedContainer} to retain binary compatibility.
     *
     * @return The target {@link Container}.
     */
    C getContainer();

    /**
     * Duplicated from {@link EmbeddedDeployedContainer} to retain binary compatibility.
     *
     * @param container The target {@link Container}.
     */
    void setContainer(C container);

    void setBoundConfigurationItems(Set<ConfigurationItem> boundConfigurationItems);

    Set<ConfigurationItem> getBoundConfigurationItems();
}
