/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.rules;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
/**
 *  Marks a field of a step to be registered as an input parameter of the step. This will expose them to xml 'xl-rules.xml'.
 */
public @interface StepParameter {

    /**
     * @return Name of the step parameter as used in xml.
     */
    String name() default "";

    /**
     * @return Description of the parameter.
     */
    String description();

    /**
     * @return whether or not this parameter is required. Defaults to true.
     */
    boolean required() default true;

    /**
     * @return whether or not value for this parameter is calculated by rule engine. Defaults to false.
     */
    boolean calculated() default false;
}
