/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.services;

import com.xebialabs.deployit.plugin.api.deployment.planning.ReadOnlyRepository;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import java.util.List;

@SuppressWarnings("deprecation")
public interface Repository extends ReadOnlyRepository {
    boolean exists(String id);

    /**
     * Returns an item by given id.
     * Throws a {@link RuntimeException} when there is no such item in repository.
     */
    <T extends ConfigurationItem> T read(String id);

    <T extends ConfigurationItem> List<T> read(List<String> ids, Integer depth);

    @SuppressWarnings("unchecked")
    <T extends ConfigurationItem> void create(T... entity);

    @SuppressWarnings("unchecked")
    <T extends ConfigurationItem> void update(T... entity);

    @SuppressWarnings("unchecked")
    <T extends ConfigurationItem> void createOrUpdate(T... entity);

    void delete(String... id);

    void move(String id, String newId);

    void rename(String id, String newName);

    /**
     * Search for all {@link ConfigurationItem}s of the specified {@link com.xebialabs.deployit.plugin.api.reflect.Type}.
     * @param type
     *          The {@link com.xebialabs.deployit.plugin.api.reflect.Type} of the {@link ConfigurationItem}s to search for.
     * @return A {@link List} of {@link ConfigurationItem}s of the {@link com.xebialabs.deployit.plugin.api.reflect.Type} passed in.
     */
    <T extends ConfigurationItem> List<T> search(Type type);

    /**
     * Search for all {@link ConfigurationItem}s of the specified {@link Type} under a parent node
     *
     * @param type
     *          The {@link Type} of the {@link ConfigurationItem}s to search for.
     *
     * @param parent
     *          The id of the parent node under which to search.
     *
     * @return A {@link List} of {@link ConfigurationItem}s of the {@link Type} which are located under the parent node.
     */
    <T extends ConfigurationItem> List<T> search(Type type, String parent);

}
