/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm;

import java.util.Map;

/**
 * Provide support for encrypted entries.
 * This is used by XebiaLabs {@link Dictionary} implementation which is responsible for encryption of entries.
 */
public interface IEncryptedDictionary extends IDictionary {

    /**
     * @return The encrypted dictionary entries
     */
    Map<String, String> getEncryptedEntries();
}
