/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

/**
 * Containers are configuration items (CIs) that {@link Deployable} CIs can be deployed to. The result of the deployment
 * is represented as a {@link Deployed}.
 *
 * Containers are grouped together in an {@link Environment}. Examples of containers are a host, WebSphere server
 * or WebLogic cluster.
 */
@PublicApiRef
@TypeIcon(value = "icons/types/udm.Container.svg")
public interface Container extends ConfigurationItem, Taggable {
}
