/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.ClassUtils;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.SyntheticHelper;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Prefix;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;

public class Descriptor {
    static final String PLACEHOLDERS_FIELD = "placeholders";
    private Type type;
    private Class<? extends ConfigurationItem> clazz;
    private String description;
    private Metadata.ConfigurationItemRoot root;
    private List<Type> superclasses = Lists.newArrayList();
    private Set<Type> interfaces = Sets.newHashSet();
    private boolean virtual;
    private Map<String, PropertyDescriptor> properties = Maps.newLinkedHashMap();
    private Type deployableType;
    private Type containerType;
    private Type generatedDeployableType;
    private Type generatedDeployableBase;
    private String generatedDeployableDescription;
    private boolean hierarchyInitialized = false;

    private Descriptor(Class<? extends ConfigurationItem> clazz) {
        this.type = Type.valueOf(clazz);
        this.clazz = clazz;
    }

    private Descriptor(Type type) {
        this.type = type;
    }

    static Descriptor from(Class<? extends ConfigurationItem> clazz) {
        try {
            Descriptor descriptor = new Descriptor(clazz);
            descriptor.initMetadata();
            descriptor.scanClass();
            return descriptor;
        }
        catch (RuntimeException e) {
            throw new DescriptorException("Could not create descriptor for: " + clazz.getName(), e);
        }
    }

    private void initMetadata() {
        Metadata annotation = (Metadata)Preconditions.checkNotNull((Object)this.clazz.getAnnotation(Metadata.class), (Object)("Class " + this.clazz.getName() + " or one of its ancestors does not have a @Metadata annotation"));
        this.description = annotation.description();
        this.root = annotation.root();
        this.virtual = annotation.virtual() || Modifier.isAbstract(this.clazz.getModifiers());
    }

    private void scanClass() {
        this.findProperties();
        this.findInterfaces();
        Class<? extends ConfigurationItem> superclass = this.clazz.getSuperclass();
        if (ConfigurationItem.class.isAssignableFrom(superclass)) {
            Type supertype = Type.valueOf(superclass);
            this.addSuperClass(supertype);
        }
        this.initDeployableAndContainerTypes();
    }

    private void findProperties() {
        for (Field field : this.clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Property.class)) continue;
            PropertyDescriptor propertyDescriptor = PropertyDescriptor.from(this, field);
            this.addProperty(propertyDescriptor);
        }
    }

    private void findInterfaces() {
        Class<?>[] clazzInterfaces = this.clazz.getInterfaces();
        ArrayList allInterfacesFound = Lists.newArrayList();
        this.findAllSuperInterfaces(clazzInterfaces, allInterfacesFound);
        for (Class clazzInterface : allInterfacesFound) {
            if (!clazzInterface.getPackage().isAnnotationPresent(Prefix.class)) continue;
            this.addInterface(Type.valueOf(clazzInterface));
        }
    }

    private void findAllSuperInterfaces(Class<?>[] childInterfaces, List<Class<?>> allInterfacesFound) {
        for (Class<?> childInterface : childInterfaces) {
            allInterfacesFound.add(childInterface);
            this.findAllSuperInterfaces(childInterface.getInterfaces(), allInterfacesFound);
        }
    }

    private void initDeployableAndContainerTypes() {
        if (Deployed.class.isAssignableFrom(this.clazz)) {
            List<Class<?>> typeArguments = ClassUtils.getActualTypeArguments(this.clazz, Deployed.class);
            Preconditions.checkArgument((typeArguments.size() == 2 ? 1 : 0) != 0, (String)"Expected exactly a Deployable and a Container, but got %s", (Object[])new Object[]{typeArguments});
            Class<?> deployableClass = typeArguments.get(0);
            if (deployableClass != null) {
                Preconditions.checkArgument((boolean)Deployable.class.isAssignableFrom(deployableClass), (Object)"Expected first item to be a deployable");
                this.deployableType = Type.valueOf(deployableClass);
            } else {
                this.deployableType = null;
            }
            Class<?> containerClass = typeArguments.get(1);
            if (containerClass != null) {
                Preconditions.checkArgument((boolean)Container.class.isAssignableFrom(containerClass), (Object)"Expected second item to be a container");
                this.containerType = Type.valueOf(containerClass);
            } else {
                this.containerType = null;
            }
        } else {
            this.deployableType = null;
            this.containerType = null;
        }
    }

    static Descriptor from(Element typeElement) {
        Type type = SyntheticHelper.getRequiredTypeAttribute(typeElement, "type");
        Descriptor descriptor = new Descriptor(type);
        descriptor.initSynthetic(typeElement);
        return descriptor;
    }

    private void initSynthetic(Element typeElement) {
        this.description = SyntheticHelper.getOptionalStringAttribute(typeElement, "description", "Description unavailable");
        this.virtual = SyntheticHelper.getOptionalBooleanAttribute(typeElement, "virtual", false);
        Type superType = SyntheticHelper.getRequiredTypeAttribute(typeElement, "extends");
        this.addSuperClass(superType);
        this.parseSyntheticDeployableAndContainerType(typeElement);
        this.parseTypeModification(typeElement);
    }

    private void parseSyntheticDeployableAndContainerType(Element typeElement) {
        this.deployableType = SyntheticHelper.getOptionalTypeAttribute(typeElement, "deployable-type");
        this.containerType = SyntheticHelper.getOptionalTypeAttribute(typeElement, "container-type");
        List<Element> generateElements = SyntheticHelper.filterChildElementsByName(typeElement, (Predicate<String>)Predicates.equalTo((Object)"generate-deployable"));
        if (!generateElements.isEmpty()) {
            Element generateDeployable = generateElements.get(0);
            this.generatedDeployableType = SyntheticHelper.getRequiredTypeAttribute(generateDeployable, "type");
            this.generatedDeployableBase = SyntheticHelper.getRequiredTypeAttribute(generateDeployable, "extends");
            this.generatedDeployableDescription = SyntheticHelper.getOptionalStringAttribute(generateDeployable, "description", "Description unavailable");
        }
    }

    void parseTypeModification(Element element) {
        SyntheticHelper.forEach(SyntheticHelper.filterChildElementsByName(element, (Predicate<String>)Predicates.equalTo((Object)"property")), new SyntheticHelper.Closure<Element>(){

            @Override
            public void call(Element element) {
                String name = SyntheticHelper.getRequiredStringAttribute(element, "name");
                PropertyDescriptor newDesc = PropertyDescriptor.from(Descriptor.this, element);
                PropertyDescriptor oldDesc = (PropertyDescriptor)Descriptor.this.properties.get(name);
                if (oldDesc != null) {
                    newDesc.overrideWith(oldDesc);
                }
                Descriptor.this.addProperty(newDesc);
            }
        });
    }

    static Descriptor from(Descriptor deployedDescriptor) {
        Descriptor deployableDescriptor = new Descriptor(deployedDescriptor.generatedDeployableType);
        deployableDescriptor.addSuperClass(deployedDescriptor.generatedDeployableBase);
        deployableDescriptor.initDeployableFromDeployed(deployedDescriptor, deployedDescriptor.generatedDeployableDescription);
        deployableDescriptor.initHierarchy();
        return deployableDescriptor;
    }

    private void initDeployableFromDeployed(Descriptor deployedDescriptor, String generatedDeployableDescription) {
        this.description = generatedDeployableDescription == null || generatedDeployableDescription.equals("Description unavailable") ? deployedDescriptor.getDescription() + " (deployable)" : generatedDeployableDescription;
        for (PropertyDescriptor pd : deployedDescriptor.getPropertyDescriptors()) {
            boolean isReferenceField;
            boolean isUdmField = pd.getName().equals("deployable") || pd.getName().equals("container") || pd.getName().equals(PLACEHOLDERS_FIELD);
            boolean bl = isReferenceField = pd.getKind() == PropertyKind.CI || pd.getKind() == PropertyKind.SET_OF_CI;
            if (isUdmField || isReferenceField || pd.isHidden()) continue;
            this.addProperty(PropertyDescriptor.generateDeployableFrom(this, pd));
        }
    }

    void initHierarchy() {
        if (this.hierarchyInitialized || this.superclasses.isEmpty()) {
            return;
        }
        Type toInitFrom = this.superclasses.get(0);
        do {
            Descriptor superDesc;
            if ((superDesc = DescriptorRegistry.getDescriptor(toInitFrom)) == null) {
                throw new IllegalStateException("Cannot build type hierarchy for " + this.getType() + " because one of its supertypes cannot be found: " + toInitFrom + " not found");
            }
            if (this.root == null) {
                this.root = superDesc.getRoot();
            }
            if (this.clazz == null) {
                this.clazz = superDesc.clazz;
            }
            this.inheritPropertyDescriptors(this.properties, superDesc.properties);
            for (Type superclass : superDesc.superclasses) {
                this.addSuperClass(superclass);
            }
            for (Type intf : superDesc.interfaces) {
                this.addInterface(intf);
            }
            Type type = toInitFrom = superDesc.superclasses.isEmpty() || superDesc.hierarchyInitialized ? null : superDesc.getSuperClasses().get(0);
            if (this.deployableType == null) {
                this.deployableType = superDesc.getDeployableType();
            }
            if (this.containerType != null) continue;
            this.containerType = superDesc.getContainerType();
        } while (toInitFrom != null);
        this.validate();
        this.hierarchyInitialized = true;
    }

    private void validate() {
        this.validateReferenceTypes();
        this.validateNonArtifactDoesNotHavePlaceholders();
        this.validateArtifactInterfaces();
        if (!this.isVirtual()) {
            this.validateJavaClassIsNotAbstract();
            this.validateDeployedHasDeployableAndContainerType();
            this.validateHiddenRequiredPropertiesHaveDefaultValue();
        }
    }

    private void validateReferenceTypes() {
        for (PropertyDescriptor p : this.properties.values()) {
            if (p.getKind() != PropertyKind.CI && p.getKind() != PropertyKind.SET_OF_CI) continue;
            Preconditions.checkState((boolean)this.isValidReferencedType(p.getReferencedType()), (String)"Property %s of type %s refers to non-existing type %s", (Object[])new Object[]{p.getName(), p.getDeclaringDescriptor().getType(), p.getReferencedType()});
        }
    }

    private boolean isValidReferencedType(Type referencedType) {
        if (DescriptorRegistry.exists(referencedType)) {
            return true;
        }
        for (Descriptor d : DescriptorRegistry.getDescriptors()) {
            if (d.getSuperClasses().contains(referencedType)) {
                return true;
            }
            if (!d.getInterfaces().contains(referencedType)) continue;
            return true;
        }
        return false;
    }

    private void validateNonArtifactDoesNotHavePlaceholders() {
        if (!this.isAssignableTo(Artifact.class)) {
            for (PropertyDescriptor propertyDescriptor : this.properties.values()) {
                Preconditions.checkState((!propertyDescriptor.getName().equals(PLACEHOLDERS_FIELD) ? 1 : 0) != 0, (String)"Type %s that does not implemnt the udm.Artifact interface must not have a field called 'placeholders'", (Object[])new Object[]{this.type});
            }
        }
    }

    private void validateArtifactInterfaces() {
        if (this.isAssignableTo(Deployable.class) && this.isAssignableTo(Artifact.class)) {
            Preconditions.checkState((boolean)this.isAssignableTo(SourceArtifact.class), (String)"Type %s that implements the udm.Deployable and udm.Artifact interface must also implement the udm.SourceArtifact interface", (Object[])new Object[]{this.type});
            Preconditions.checkState((boolean)this.isAssignableTo(DeployableArtifact.class), (String)"Type %s that implements the udm.Deployable and udm.Artifact interface must also implement the udm.DeployableArtifact interface", (Object[])new Object[]{this.type});
        }
        if (this.isAssignableTo(Deployed.class) && this.isAssignableTo(Artifact.class)) {
            Preconditions.checkState((boolean)this.isAssignableTo(DerivedArtifact.class), (String)"Type %s that implements the udm.Deployed and udm.Artifact interface must also implement the udm.DerivedArtifact interface", (Object[])new Object[]{this.type});
        }
    }

    private void validateJavaClassIsNotAbstract() {
        Preconditions.checkState((!Modifier.isAbstract(this.clazz.getModifiers()) ? 1 : 0) != 0, (String)"Non-virtual type %s has an abstract Java class %s", (Object[])new Object[]{this.getType(), this.clazz.getName()});
    }

    private void validateDeployedHasDeployableAndContainerType() {
        Type deployedType = Type.valueOf(Deployed.class);
        if (this.isAssignableTo(deployedType)) {
            Preconditions.checkState((this.getDeployableType() != null ? 1 : 0) != 0, (String)"Non-virtual type %s is a sub-type of %s but does not have a deployable-type", (Object[])new Object[]{this.getType(), deployedType});
            Preconditions.checkState((this.getContainerType() != null ? 1 : 0) != 0, (String)"Non-virtual type %s is a sub-type of %s but does not have a container-type", (Object[])new Object[]{this.getType(), deployedType});
        }
    }

    private void validateHiddenRequiredPropertiesHaveDefaultValue() {
        for (PropertyDescriptor p : this.properties.values()) {
            if (!p.isHidden() || !p.isRequired()) continue;
            Preconditions.checkState((p.getDefaultValue() != null ? 1 : 0) != 0, (String)"Hidden required property %s of non-virtual type %s must have a default value", (Object[])new Object[]{p.getName(), this.getType()});
        }
    }

    private void inheritPropertyDescriptors(Map<String, PropertyDescriptor> dest, Map<String, PropertyDescriptor> source) {
        for (String sourceKey : source.keySet()) {
            if (!dest.containsKey(sourceKey)) {
                dest.put(sourceKey, source.get(sourceKey));
                continue;
            }
            dest.get(sourceKey).overrideWith(source.get(sourceKey));
        }
    }

    private void addSuperClass(Type supertype) {
        this.superclasses.add(supertype);
        DescriptorRegistry.registerSubtype(supertype, this.type);
    }

    private void addInterface(Type intf) {
        DescriptorRegistry.registerSubtype(intf, this.type);
        this.interfaces.add(intf);
    }

    void addProperty(PropertyDescriptor propertyDescriptor) {
        this.properties.put(propertyDescriptor.getName(), propertyDescriptor);
    }

    public Type getType() {
        return this.type;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public String getDescription() {
        return this.description;
    }

    public Metadata.ConfigurationItemRoot getRoot() {
        return this.root;
    }

    public Collection<PropertyDescriptor> getPropertyDescriptors() {
        return this.properties.values();
    }

    public PropertyDescriptor getPropertyDescriptor(String name) {
        return this.properties.get(name);
    }

    public boolean isAssignableTo(Class<?> clazz) {
        return this.isAssignableTo(Type.valueOf(clazz));
    }

    public boolean isAssignableTo(Type type) {
        return DescriptorRegistry.getSubtypes(type).contains(this.type) || this.type.equals(type);
    }

    public List<Type> getSuperClasses() {
        return this.superclasses;
    }

    public Set<Type> getInterfaces() {
        return this.interfaces;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public boolean areEqual(ConfigurationItem item, ConfigurationItem other) {
        return this.areEqual(item, other, new HashSet<String>());
    }

    boolean areEqual(ConfigurationItem item, ConfigurationItem other, Set<String> itemsBeingCompared) {
        if (item == null) {
            return other == null;
        }
        if (!this.getType().equals(item.getType()) || !this.getType().equals(other.getType())) {
            return false;
        }
        if (!itemsBeingCompared.add(item.getId())) {
            return true;
        }
        for (PropertyDescriptor pd : this.getPropertyDescriptors()) {
            if (pd.areEqual(item, other, itemsBeingCompared)) continue;
            return false;
        }
        return true;
    }

    boolean shouldGenerateDeployableType() {
        return this.generatedDeployableType != null;
    }

    public <T extends ConfigurationItem> T newInstance() {
        if (this.virtual) {
            throw new IllegalArgumentException("Cannot instantiate class for " + this.type + " because it is virtual");
        }
        try {
            Field typeField = this.searchField(this.clazz, "type");
            typeField.setAccessible(true);
            ConfigurationItem t = this.clazz.newInstance();
            typeField.set(t, this.type);
            this.prefillDefaultProperties(t);
            return (T)t;
        }
        catch (InstantiationException exc) {
            throw new RuntimeException("Cannot instantiate class " + this.clazz.getName(), exc);
        }
        catch (IllegalAccessException exc) {
            throw new RuntimeException("Cannot instantiate class " + this.clazz.getName(), exc);
        }
    }

    private <T extends ConfigurationItem> void prefillDefaultProperties(T t) {
        for (PropertyDescriptor pd : this.getPropertyDescriptors()) {
            if (pd.getDefaultValue() == null) continue;
            pd.set(t, pd.getDefaultValue());
        }
    }

    private Field searchField(Class<?> clazz, String name) {
        Class<?> scan = clazz;
        while (!scan.equals(Object.class)) {
            try {
                return scan.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                scan = scan.getSuperclass();
            }
        }
        throw new IllegalArgumentException("Cannot find '" + name + "' field on " + clazz.getName());
    }

    public String toString() {
        return "Descriptor[" + this.type + "]";
    }

    public Type getDeployableType() {
        return this.deployableType;
    }

    public Type getContainerType() {
        return this.containerType;
    }

    private static class DescriptorException
    extends RuntimeException {
        public DescriptorException(String s, RuntimeException e) {
            super(s, e);
        }
    }
}

