package com.xebialabs.deployit.plugin.api.udm;

import static com.google.common.collect.Maps.newHashMap;
import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.ENVIRONMENTS;

import java.util.Map;

import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;

@SuppressWarnings("serial")
@Metadata(root = ENVIRONMENTS, description = "A Dictionary contains key-value pairs that can be replaced")
public class Dictionary extends BaseConfigurationItem {

	@Property(description = "The dictionary entries")
	private Map<String, String> entries = newHashMap();

	public void setEntries(Map<String, String> dict) {
		this.entries = dict;
	}

	public Map<String, String> getEntries() {
		return entries;
	}

	public String getValue(String key) {
		return entries.get(key);
	}

	public boolean hasValue(String key) {
		return entries.containsKey(key);
	}

}
