/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.udm;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Dictionary;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

@Metadata(description="A group where middleware CI's can be added, can serve as a target for a deployment.", root=Metadata.ConfigurationItemRoot.ENVIRONMENTS)
public class Environment
extends BaseConfigurationItem {
    @Property
    private Set<Container> members = Sets.newHashSet();
    @Property
    private Set<Dictionary> dictionaries = Sets.newHashSet();

    public Environment() {
    }

    public Environment(Container ... members) {
        HashSet memberSet = Sets.newHashSet();
        for (Container each : members) {
            memberSet.add(each);
        }
        this.setMembers(memberSet);
    }

    public Set<Container> getMembers() {
        return this.members;
    }

    public <T extends Serializable> Set<T> getMembersOfType(Class<T> classType) {
        HashSet<Container> matchingMembers = new HashSet<Container>();
        for (Container member : this.getMembers()) {
            if (!classType.isInstance(member)) continue;
            matchingMembers.add(member);
        }
        return matchingMembers;
    }

    public void setMembers(Set<Container> members) {
        this.members = members;
    }

    public void addMember(Container member) {
        this.members.add((Container)Preconditions.checkNotNull((Object)member));
    }

    public Set<Dictionary> getDictionaries() {
        return this.dictionaries;
    }

    public void setDictionaries(Set<Dictionary> dictionaries) {
        this.dictionaries = dictionaries;
    }
}

