package com.xebialabs.deployit.plugin.api.deployment.planning;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;

import java.util.Collection;

/**
 * Context that is passed along during the Planning stage of a Deployment. This can be used to add {@link DeploymentStep} to the current plan,
 * or store and retrieve attributes to transfer knowledge between multiple Contributors/Processors.
 */
public interface DeploymentPlanningContext {

	/**
	 * Add a step to the current plan.
	 * @param step the step to add.
	 */
    void addStep(DeploymentStep step);

	/**
	 * Add multiple steps to the current plan.
	 * @param steps the steps to add.
	 */
    void addSteps(DeploymentStep... steps);

	/**
	 * Add multiple steps to the current plan.
	 * @param steps the steps to add.
	 */
    void addSteps(Collection<DeploymentStep> steps);

	/**
	 * Returns the planning context attribute with the given name, or <tt>null</tt> if there is no attribute by that name.
	 * 
	 * @param name
	 *            the name of the attribute
	 * @return the value of the attribute, or <tt>null</tt> if there is no attribute by that name.
	 */
	Object getAttribute(String name);

	/**
	 * Stores an attribute in the planning context. This attribute will be available while the deployment plan is being created.
	 * 
	 * @param name
	 *            the name of the attribute
	 * @param value
	 *            the value of the attribute
	 */
	void setAttribute(String name, Object value);

	/**
	 * Returns the DeployedApplication for which the plan is being created.
	 *
	 * @return the DeployedApplication for which the plan is being created.
	 */
	DeployedApplication getDeployedApplication();

}
