package com.xebialabs.deployit.plugin.api.udm;

import java.lang.annotation.*;

/**
 * A control task is a method that can be invoked on a ConfigurationItem, to perform some action.
 * For instance, that starting or stopping of a Container.
 *
 * A @ControlTask method should adhere to the following rules:
 * - take no parameters
 * - return a List&lt;Step&gt;
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
@Inherited
public @interface ControlTask {

	String description() default "no description";
}
