package com.xebialabs.deployit.plugin.api.deployment.planning;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * A PostProcessor for a Plan. PostProcessors are allowed to add steps to the very end of a plan.
 * These added steps will only be ordered relative to all the steps added by {@link PostPlanProcessor}s, not with respect to all the steps in the plan.
 *
 * PostProcessors are executed in an ordered fashion. Their ordering is the following:
 * <ol>
 *     <li>A lower {@link com.xebialabs.deployit.plugin.api.deployment.planning.PostPlanProcessor#order()} god before a higher order (default 100).</li>
 *     <li>Same orders are ordered alphabetically by {@link Class#getSimpleName()} of the class of the annotated PostProcessor.</li>
 *     <li>Same class names are ordered by {@link java.lang.reflect.Method#getName()} of the annotated method</li>
 * </ol>
 *
 * A method annotated with {@link }PostPlanProcessor} should take the following parameters:
 * <url>
 *     <li>{@link com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification} The specification for the current deployment</li>
 * </url>
 * The method should return either a {@link com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep} or a {@link java.util.List} of {@link com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep}.
 *
 * The class that contains this annotated method should have a default or no-arg constructor.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface PostPlanProcessor {
	int order() default 100;
}
