/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.boot;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginVersions {
    private static final Map<String, String> PLUGIN_VERSIONS = Maps.newHashMap();
    private static final Logger logger = LoggerFactory.getLogger(PluginVersions.class);

    static void init() {
        try {
            Enumeration<URL> enumeration = Thread.currentThread().getContextClassLoader().getResources("plugin-version.properties");
            ArrayList arrayList = Lists.newArrayList((Iterator)Iterators.forEnumeration(enumeration));
            for (URL uRL : arrayList) {
                PluginVersions.readPluginVersion((InputSupplier<InputStream>)Resources.newInputStreamSupplier((URL)uRL));
            }
        }
        catch (IOException iOException) {
            logger.error("Couldn't read plugin-version.properties", (Throwable)iOException);
            throw new IllegalStateException(iOException);
        }
    }

    public static String getVersionFor(String string) {
        return PLUGIN_VERSIONS.get(string);
    }

    public static Set<String> getRegisteredPlugins() {
        return PLUGIN_VERSIONS.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readPluginVersion(InputSupplier<InputStream> inputSupplier) throws IOException {
        InputStream inputStream = (InputStream)inputSupplier.getInput();
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            String string = properties.getProperty("plugin");
            String string2 = properties.getProperty("version");
            PLUGIN_VERSIONS.put(string, string2);
        }
        finally {
            Closeables.closeQuietly((Closeable)inputStream);
        }
    }
}

