package com.xebialabs.deployit.plugin.api.reflect;

import static nl.javadude.scannit.Configuration.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;

import nl.javadude.scannit.Scannit;
import nl.javadude.scannit.scanner.MethodAnnotationScanner;
import nl.javadude.scannit.scanner.SubTypeScanner;
import nl.javadude.scannit.scanner.TypeAnnotationScanner;

public class ReflectionsHolder {

    private static final Scannit scannit = new Scannit(config()
		    .scan("com.xebialabs")
		    .scan("ext.deployit") // Deployit Extensions
		    .with(new TypeAnnotationScanner(), new MethodAnnotationScanner(), new SubTypeScanner()));

    public static <T> Set<Class<? extends T>> getSubTypesOf(Class<T> clazz) {
        return scannit.getSubTypesOf(clazz);
    }

    public static Set<Method> getMethodsAnnotatedWith(Class<? extends Annotation> annotation) {
        return scannit.getMethodsAnnotatedWith(annotation);
    }

    public static Set<Field> getFieldsAnnotatedWith(Class<? extends Annotation> annotation) {
        return scannit.getFieldsAnnotatedWith(annotation);
    }

	public static Set<Class<?>> getClassesAnnotatedWith(Class<? extends Annotation> annotation) {
		return scannit.getTypesAnnotatedWith(annotation);
	}
}
