package com.xebialabs.deployit.plugin.api.validation;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import java.util.Collection;

public class ReferenceCollectionTypeValidator implements Validator<Collection<ConfigurationItem>> {

    private PropertyDescriptor propertyDescriptor;

    public ReferenceCollectionTypeValidator(PropertyDescriptor propertyDescriptor) {
        this.propertyDescriptor = propertyDescriptor;
    }

    @Override
    public void validate(Collection<ConfigurationItem> value, ValidationContext context) {
        Type referencedType = propertyDescriptor.getReferencedType();
        for (ConfigurationItem ci : value) {
            if (!referencedType.isSuperTypeOf(ci.getType()) && !referencedType.equals(ci.getType())) {
                context.error("Cannot set [%s] with ci [%s] as it is not of type [%s]", propertyDescriptor.getFqn(), ci.getId(), referencedType);
            }
        }
    }
}
