package com.xebialabs.deployit.plugin.api.udm.base;

import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;

import java.util.Set;

import static com.google.common.collect.Sets.newHashSet;


/**
 * Anything that is deployable to a {@link Container}
 */
@SuppressWarnings("serial")
@Metadata(virtual = true)
public class BaseDeployable extends BaseConfigurationItem implements Deployable {
	@Property(required = false, category = "Deployment", description = "If set, this deployable will only be mapped automatically to containers with the same tag.")
	private Set<String> tags = newHashSet();

	@Override
	public Set<String> getTags() {
		return tags;
	}

	@Override
	public void setTags(Set<String> tags) {
		this.tags = tags;
	}

}
