/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalContext {
    private static final Logger logger = LoggerFactory.getLogger(GlobalContext.class);
    private static final Map<String, Value> context = new MapMaker().makeComputingMap((Function)new Function<String, Value>(){

        public Value apply(String string) {
            return new Value("", null);
        }
    });
    public static final File DEFAULTS = new File("conf", "deployit-defaults.properties");

    private GlobalContext() {
    }

    static void register(PropertyDescriptor propertyDescriptor, String string) {
        if (string == null && !propertyDescriptor.isHidden()) {
            return;
        }
        context.put(GlobalContext.constructPropertyName(propertyDescriptor), new Value(propertyDescriptor.getDescription(), string));
    }

    public static void register(PropertyDescriptor propertyDescriptor, PropertyDescriptor propertyDescriptor2) {
        context.put(GlobalContext.constructPropertyName(propertyDescriptor), new InheritedValue(propertyDescriptor.getDescription(), GlobalContext.constructPropertyName(propertyDescriptor2), propertyDescriptor.isHidden()));
    }

    public static void update(PropertyDescriptor propertyDescriptor, String string) {
        context.put(GlobalContext.constructPropertyName(propertyDescriptor), new Value(propertyDescriptor.getDescription(), string));
    }

    private static String constructPropertyName(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getDeclaringDescriptor().getType() + "." + propertyDescriptor.getName();
    }

    static String lookup(PropertyDescriptor propertyDescriptor) {
        return GlobalContext.lookup(GlobalContext.constructPropertyName(propertyDescriptor));
    }

    private static String lookup(String string) {
        if (!context.containsKey(string)) {
            return null;
        }
        return context.get(string).getValue();
    }

    static void loadStoredDefaults(File file) {
        if (!file.exists()) {
            logger.info("Could not find '" + file + "', continuing without loading defaults");
            return;
        }
        if (file.isDirectory()) {
            logger.error(file + " is a directory but should be a plain file, aborting!");
            throw new IllegalStateException("Please remove " + file + " and try again.");
        }
        try {
            Files.readLines((File)file, (Charset)Charset.defaultCharset(), (LineProcessor)new LineProcessor<Object>(){

                public boolean processLine(String string) throws IOException {
                    if (!string.startsWith("#") && string.contains("=")) {
                        int n = string.indexOf("=");
                        String string2 = string.substring(0, n);
                        Value value = (Value)context.get(string2);
                        context.put(string2, new ExplicitValue(value.description, string.substring(n + 1)));
                    }
                    return true;
                }

                public Object getResult() {
                    return null;
                }
            });
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Could not read '" + file.toString() + "'", iOException);
        }
    }

    public static void storeDefaults() {
        GlobalContext.storeDefaults(DEFAULTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static void storeDefaults(File file) {
        block11: {
            BufferedWriter bufferedWriter;
            block10: {
                bufferedWriter = null;
                if (file.getParentFile().exists() && file.getParentFile().isDirectory()) break block10;
                logger.warn("Not writing {} because the directory does not exist", (Object)file);
                Closeables.closeQuietly(bufferedWriter);
                return;
            }
            try {
                bufferedWriter = Files.newWriter((File)file, (Charset)Charset.defaultCharset());
                ArrayList arrayList = Lists.newArrayList(context.keySet());
                Collections.sort(arrayList);
                for (String string : arrayList) {
                    Value value = context.get(string);
                    if (!value.isShouldWrite()) continue;
                    if (!Strings.isNullOrEmpty((String)value.description)) {
                        bufferedWriter.append("# ").append(value.description);
                        if (value instanceof InheritedValue) {
                            InheritedValue inheritedValue = (InheritedValue)value;
                            bufferedWriter.append(" (inherited from: ").append(inheritedValue.superTypeProperty).append(")");
                        }
                        bufferedWriter.newLine();
                    }
                    bufferedWriter.append(value.isExplicit() ? "" : "#").append(string).append('=').append(value.getValue());
                    bufferedWriter.newLine();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.error("Could not start writing to '" + file + "'", (Throwable)fileNotFoundException);
                Closeables.closeQuietly((Closeable)bufferedWriter);
                break block11;
            }
            catch (IOException iOException) {
                logger.error("Could not write to '" + file + "'", (Throwable)iOException);
                {
                    catch (Throwable throwable) {
                        Closeables.closeQuietly(bufferedWriter);
                        throw throwable;
                    }
                }
                Closeables.closeQuietly((Closeable)bufferedWriter);
            }
            Closeables.closeQuietly((Closeable)bufferedWriter);
        }
    }

    static void validateValues() {
        boolean bl = true;
        ArrayList arrayList = Lists.newArrayList();
        for (String string : context.keySet()) {
            PropertyDescriptor propertyDescriptor;
            Descriptor descriptor;
            int n = string.lastIndexOf(46);
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            Type type = Type.valueOf(string2);
            if (!DescriptorRegistry.exists(type) || (descriptor = DescriptorRegistry.getDescriptor(type)).isVirtual() || (propertyDescriptor = descriptor.getPropertyDescriptor(string3)) == null) continue;
            try {
                propertyDescriptor.getDefaultValue();
                if (!propertyDescriptor.isRequired() || !propertyDescriptor.isHidden() || !Strings.isNullOrEmpty((String)GlobalContext.lookup(propertyDescriptor))) continue;
                bl = false;
                arrayList.add(String.format("Cannot register empty default value for hidden required property [%s]", string));
            }
            catch (RuntimeException runtimeException) {
                bl = false;
                arrayList.add(String.format("Incorrect default registered: [%s] with value %s", string, context.get(string).getValue()));
            }
        }
        if (!bl) {
            String string = Joiner.on((String)"\n").join((Iterable)arrayList);
            logger.error(string);
            throw new IllegalStateException("Could not initialize the default values, please look at the log and correct the defaults file: " + DEFAULTS + "\n" + (String)string);
        }
    }

    static class ExplicitValue
    extends Value {
        ExplicitValue(String string, String string2) {
            super(string, string2);
        }

        @Override
        boolean isExplicit() {
            return true;
        }
    }

    static class Value {
        final String description;
        final String value;

        Value(String string, String string2) {
            this.description = string;
            this.value = string2;
        }

        boolean isExplicit() {
            return false;
        }

        boolean isShouldWrite() {
            return true;
        }

        public String getValue() {
            return this.value;
        }
    }

    static class InheritedValue
    extends Value {
        private final String superTypeProperty;
        private final boolean shouldWrite;

        InheritedValue(String string, String string2, boolean bl) {
            super(string, "");
            this.superTypeProperty = string2;
            this.shouldWrite = bl;
        }

        @Override
        public String getValue() {
            return GlobalContext.lookup(this.superTypeProperty);
        }

        @Override
        boolean isShouldWrite() {
            return this.shouldWrite;
        }
    }
}

