/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.udm.Prefix;
import java.io.Serializable;

public class Type
implements Serializable {
    private String prefix;
    private String name;

    private Type(String string, String string2) {
        Preconditions.checkNotNull((Object)string, (Object)"prefix");
        Preconditions.checkNotNull((Object)string2, (Object)"type");
        this.prefix = string;
        this.name = string2;
    }

    public static Type valueOf(Class<?> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"Cannot get the type of a null class");
        Package package_ = clazz.getPackage();
        Prefix prefix = package_.getAnnotation(Prefix.class);
        Preconditions.checkNotNull((Object)prefix, (String)"Package [%s] should have an @Prefix annotation for ci-class [%s]", (Object[])new Object[]{package_.getName(), clazz.getName()});
        String string = clazz.getSimpleName();
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)string), (String)"Could not get a typename for ci-class [%s]", (Object[])new Object[]{clazz.getName()});
        return Type.valueOf(prefix.value(), string);
    }

    public static Type valueOf(String string) {
        Preconditions.checkNotNull((Object)string, (Object)"Cannot get the type of a null typeName String");
        Preconditions.checkArgument((string.indexOf(46) != -1 ? 1 : 0) != 0, (String)"Type %s does not contain a prefix", (Object[])new Object[]{string});
        int n = string.lastIndexOf(46);
        return Type.valueOf(string.substring(0, n), string.substring(n + 1));
    }

    public static Type valueOf(String string, String string2) {
        return new Type(string, string2);
    }

    public Descriptor getDescriptor() {
        return DescriptorRegistry.getDescriptor(this);
    }

    public boolean isSubTypeOf(Type type) {
        return DescriptorRegistry.getSubtypes(type).contains(this);
    }

    public boolean instanceOf(Type type) {
        return this.equals(type) || DescriptorRegistry.getSubtypes(type).contains(this);
    }

    public boolean isSuperTypeOf(Type type) {
        return DescriptorRegistry.getSubtypes(this).contains(type);
    }

    public boolean exists() {
        return DescriptorRegistry.exists(this);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Type type = (Type)object;
        return this.prefix.equals(type.prefix) && this.name.equals(type.name);
    }

    public int hashCode() {
        int n = this.prefix != null ? this.prefix.hashCode() : 0;
        n = 31 * n + (this.name != null ? this.name.hashCode() : 0);
        return n;
    }

    public String toString() {
        return this.prefix + "." + this.name;
    }
}

