package com.xebialabs.deployit.plugin.api.udm;

import java.lang.annotation.*;

/**
 * A delegate can execute a control task on a ConfigurationItem, to perform some action.
 * <p/>
 * A @Delegate method should adhere to the following rules:
 * <ul>
 *     <li>The constructor of the object should take no arguments</li>
 *     <li>The method should take the following 3 parameters:
 *     <ol>
 *         <li>A ConfigurationItem (The item the method is invoked on).</li>
 *         <li>A String (the name of the method invoked).</li>
 *         <li>A Map&lt;String, String&gt; (The attributes of the method invoked).</li>
 *     </ol>
 *     </li>
 *     <li>The method should return a List&lt;{@link com.xebialabs.deployit.plugin.api.flow.Step}&gt;</li>
 * </ul>
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
@Inherited
public @interface Delegate {
    String name();
}
