package com.xebialabs.deployit.plugin.api.udm;

import java.lang.annotation.*;

/**
 * Specifies that this class is a configuration item.
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Inherited
public @interface Metadata {

    /**
     * The description of this configuration item.
     */
    String description() default "Description unavailable";

    /**
     * The root under which to place configuration items of this type in the JCR tree. If {@link ConfigurationItemRoot#NESTED} is specified, configuration items
     * of this type cannot be placed directly under a root.
     */
    ConfigurationItemRoot root() default ConfigurationItemRoot.NESTED;

    /**
     * Whether or not this is a virtual type.
     * @return
     */
    boolean virtual() default false;

    /**
     * Whether or not the type is inspectable (default false)
     * @return
     */
    boolean inspectable() default false;

    /**
     * The root in the JCR tree.
     */
    public enum ConfigurationItemRoot {

        APPLICATIONS("Applications"),

        INFRASTRUCTURE("Infrastructure"),

        ENVIRONMENTS("Environments"),

        CONFIGURATION("Configuration"),
        
        NESTED(null);

        private String rootNodeName;

        private ConfigurationItemRoot(String rootNodeName) {
            this.rootNodeName = rootNodeName;
        }

        public String getRootNodeName() {
            return rootNodeName;
        }

    }
}
