package com.xebialabs.deployit.plugin.api.deployment.specification;

import com.xebialabs.deployit.plugin.api.udm.Deployed;

import java.io.Serializable;

/**
 * The Delta specifies what will happen to a Deployed in a Deployment.
 * if the operation == CREATE -> previous == null && deployed is set
 * if the operation == UPDATE -> previous is set && deployed is set
 * if the operation == DELETE -> previous is set && deployed == null
 * if the operation == NOOP -> previous and deployed are set to the same value.
 */
public interface Delta extends Serializable {
    Operation getOperation();

    Deployed<?, ?> getPrevious();
    Deployed<?, ?> getDeployed();
}
