package com.xebialabs.deployit.plugin.api.reflect;

import com.google.common.collect.Iterators;

import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;

import static com.google.common.base.Preconditions.checkState;
import static com.google.common.collect.Lists.newArrayList;

public abstract class DescriptorRegistry {
    private static final AtomicReference<DescriptorRegistry> REGISTRY = new AtomicReference<DescriptorRegistry>();

    static {
        ServiceLoader<DescriptorRegistry> registryLoader = ServiceLoader.load(DescriptorRegistry.class);
        List<DescriptorRegistry> registries = newArrayList();
        Iterators.addAll(registries, registryLoader.iterator());
        checkState(registries.size() == 1, "Should have exactly 1 implementation of %s on the classpath (Found: %s)", DescriptorRegistry.class.getName(), registries);
        REGISTRY.compareAndSet(null, registries.get(0));
    }

    public static Collection<Descriptor> getDescriptors() {
        return REGISTRY.get()._getDescriptors();
    }

    public static Collection<Type> getSubtypes(Type supertype) {
        return REGISTRY.get()._getSubtypes(supertype);
    }

    public static Descriptor getDescriptor(String prefixedName) {
        return getDescriptor(Type.valueOf(prefixedName));
    }

    public static Descriptor getDescriptor(String prefix, String name) {
        return getDescriptor(Type.valueOf(prefix, name));
    }

    public static Descriptor getDescriptor(Type type) {
        return REGISTRY.get()._getDescriptor(type);
    }

    public static boolean exists(Type type) {
        return REGISTRY.get()._exists(type);
    }

    protected static DescriptorRegistry getInstance() {
        return REGISTRY.get();
    }

    protected abstract Collection<Descriptor> _getDescriptors();

    protected abstract Collection<Type> _getSubtypes(Type supertype);

    protected abstract Descriptor _getDescriptor(Type type);

    protected abstract boolean _exists(Type type);

}
