package com.xebialabs.deployit.plugin.api.udm;

/**
 * Resembles a Deployed item.
 *
 * We require the following contract:
 * - the Deployable is to be stored in a field called 'deployable'
 * - the Container is to be stored in a field called 'container'
 *
 * @param <D> Something that is a Deployable
 * @param <C> Something that is a Container
 */
public interface Deployed<D extends Deployable, C extends Container> extends ConfigurationItem {

    static final String DEPLOYABLE_FIELD = "deployable";
    static final String CONTAINER_FIELD = "container";

    D getDeployable();

    void setDeployable(D deployable);

    C getContainer();

    void setContainer(C container);
}
