package com.xebialabs.deployit.plugin.api;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.plugin.api.udm.Version;

public final class Deprecations {

    public static void deprecated(String messageFormat, Object... params) {
        logger.warn(String.format(messageFormat, params));
    }

    public static void deprecated(Version version, String message) {
        logger.warn("**Deprecated** {} (Will be removed in {})", message, version);
    }

    private static final Logger logger = LoggerFactory.getLogger(Deprecated.class);
}
