package com.xebialabs.deployit.plugin.api.validation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;

@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@Rule(clazz = Range.Validator.class, type = "range")
public @interface Range {
    String DEFAULT_MESSAGE = "Value %s is not in range [%s, %s]";
    int MIN_VALUE = Integer.MIN_VALUE;
    int MAX_VALUE = Integer.MAX_VALUE;

    int minimum() default MIN_VALUE;

    int maximum() default MAX_VALUE;

    String message() default DEFAULT_MESSAGE;

    public static class Validator implements com.xebialabs.deployit.plugin.api.validation.Validator<Integer> {
        private int minimum = Range.MIN_VALUE;

        private int maximum = Range.MAX_VALUE;

        private String message = Range.DEFAULT_MESSAGE;

        @Override
        public void validate(final Integer value, final ValidationContext context) {
            if (value < minimum || value > maximum) {
                context.error(message, value, minimum, maximum);
            }
        }
    }
}
