/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

/**
 * Deployables are {@link ConfigurationItem}s (CIs) that can be deployed to a {@link Container}.
 *
 * There are two types of Deployables: {@link DeployableArtifact}s and resource specifications, which is a generic name
 * for any Deployable CI that is not a DeployableArtifact, for example a datasource, a queue, or a connection factory.
 *
 * Deployables are part of a {@link DeploymentPackage} or of a {@link CompositePackage}.
 */
@PublicApiRef
@TypeIcon(value = "icons/types/udm.Deployable.svg")
public interface Deployable extends ConfigurationItem, Taggable {
}
