/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of Xebialabs Software and Documentation is subject to the Personal
 * License Agreement.
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the Xebialabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemDescription;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ConfigurationItemProperty.Size;

@SuppressWarnings("serial")
@ConfigurationItem
public class WasDataSource extends BaseConfigurationItem implements WasResource {

	@ConfigurationItemProperty(required = true, label = "WebSphere name", description = "Name of the datasource.")
	private String name;

	@ConfigurationItemProperty(required = true, label = "JNDI name", description = "JNDI name, used by applications to lookup the datasource.")
	private String jndiName;

	@ConfigurationItemDescription
	private String description;

	@ConfigurationItemProperty(required = true, description = "Name of the JDBC provider, used to create the datasource.", size = Size.LARGE)
	private String provider;

	@ConfigurationItemProperty(required = true, description = "Username used to connect to the database instance.")
	private String username;

	@ConfigurationItemProperty(required = true, password = true, description = "Password used to authenticate the username with the database instance.")
	private String password;

	@ConfigurationItemProperty(required = true, description = "DataStoreHelper implementation class that extends the capabilities of the JDBC driver.", size = Size.LARGE)
	private String dataStoreHelperClass; // defaults to appropriate value for db

	@ConfigurationItemProperty(required = true, description = "DataBase Connection URL.", size = Size.LARGE)
	private String url;

	@ConfigurationItemProperty(required = false, description = "The statement cache size sets the allocation of procedure cache memory and limits the amount of memory from the procedure cache pool used for cached statements.")
	private int statementCacheSize; // defaults to application server default

	public void setName(String name) {
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public void setJndiName(String jndiName) {
		this.jndiName = jndiName;
	}

	public String getJndiName() {
		return jndiName;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getDescription() {
		return description;
	}

	public void setProvider(String provider) {
		this.provider = provider;
	}

	public String getProvider() {
		return provider;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public String getUsername() {
		return username;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getPassword() {
		return password;
	}

	public void setDataStoreHelperClass(String dataStoreHelperClass) {
		this.dataStoreHelperClass = dataStoreHelperClass;
	}

	public String getDataStoreHelperClass() {
		return dataStoreHelperClass;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getUrl() {
		return url;
	}

	public void setStatementCacheSize(int statementCacheSize) {
		this.statementCacheSize = statementCacheSize;
	}

	public int getStatementCacheSize() {
		return statementCacheSize;
	}

}
