/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of Xebialabs Software and Documentation is subject to the Personal
 * License Agreement.
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the Xebialabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Host;

@ConfigurationItem(category = "middleware", description = "A WebSphere Node. Is a member of the WebSphereCell to which it belongs and the Host in which it runs.", expandable = true)
public class WasNode extends BaseConfigurationItem {
	private static final long serialVersionUID = 179031152212999680L;

	@ConfigurationItemProperty(required = true, label = "WebSphere administrative cell")
	private WasCell cell;

	@ConfigurationItemProperty(required = true)
	private Host host;

	@ConfigurationItemProperty(required = true, label = "WebSphere name", description = "Name of the WebSphere node in the WebSphere cell, e.g. MyNode, Node01")
	private String name;

	@ConfigurationItemProperty(required = true, label = "WAS managed application server profile path", description = "Home directory of the node profile, is also the USER_INSTALL_ROOT, examples, /opt/wp/61/wp_profile")
	private String home;

	public WasCell getCell() {
		return cell;
	}

	public void setCell(WasCell cell) {
		this.cell = cell;
	}

	public Host getHost() {
		return host;
	}

	public void setHost(Host host) {
		this.host = host;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getHome() {
		return home;
	}

	public void setHome(String home) {
		this.home = home;
	}

}