/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of Xebialabs Software and Documentation is subject to the Personal
 * License Agreement.
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the Xebialabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasNode;

/**
 * Adds a single member (Server) of a {@link WasCluster WAS Cluster} to a {@link WasNode}. The cloneNumber is used in the name of the Was Server.
 */
@SuppressWarnings("serial")
public class AddSingleWasClusterMemberStep extends WasStepBase {

	protected static final String CLONE_CLUSTER_MEMBER_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "clone-cluster-member.py";

	protected WasCluster cluster;

	protected WasNode node;

	private int cloneNumber;

	public AddSingleWasClusterMemberStep(WasCluster cluster, WasNode node, int cloneNumber) {
		super(cluster.getCell());
		this.cloneNumber = cloneNumber;
		this.cluster = cluster;
		this.node = node;
		setDescription("Add a member (clone) " + cloneNumber + " for cluster \"" + cluster.getLabel() + "\" on node \"" + node.getLabel() + "\" in cell \""
				+ cell.getLabel() + "\"");
	}

	public boolean execute(StepExecutionContext ctx) {
		String clusterMemberNamesPrefix = WasCluster.getMemberNamesPrefix(cluster.getName(), node.getName());
		String startOfBootstrapPortNumberRange = Integer.toString(cluster.getStartOfBootstrapPortNumberRange());
		String startOfSoapConnectorPortNumberRange = Integer.toString(cluster.getStartOfSoapConnectorPortNumberRange());

		return (executeWsadminJythonScriptResource(ctx, CLONE_CLUSTER_MEMBER_SCRIPT_RESOURCE_PATH, node.getName(), cluster.getName(), clusterMemberNamesPrefix,
				Integer.toString(cloneNumber), startOfBootstrapPortNumberRange, "BOOTSTRAP_ADDRESS", startOfSoapConnectorPortNumberRange,
				"SOAP_CONNECTOR_ADDRESS") == 0);
	}

}
