package com.xebialabs.deployit.plugin.was.step;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;

/**
 * Tells the {@link WasCell} to generate a webserver plugin configuration for a {@link WasManagedApacheHttpdServer}
 */
@SuppressWarnings("serial")
public class GenerateWasWebServerPluginConfigurationStep extends WasStepBase {

	public static final String GENERATE_PLUGIN_CONFIG_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "generate-plugin-config.py";

	protected WasManagedApacheHttpdServer webserver;

	public GenerateWasWebServerPluginConfigurationStep(WasManagedApacheHttpdServer webserver) {
		super(webserver.getNode().getCell());
		this.webserver = webserver;
		this.description = "Generating plugin for webserver " + webserver + " on node " + webserver.getNode() + " on cell " + webserver.getNode().getCell();
	}

	public boolean execute(StepExecutionContext ctx) {
		Map<String, Serializable> context = new HashMap<String, Serializable>();
		context.put("cell", cell);
		context.put("node", webserver.getNode());
		context.put("webserver", webserver);
		int res = executeWsadminJythonScriptResource(ctx, context, GENERATE_PLUGIN_CONFIG_SCRIPT_RESOURCE_PATH);
		return res == 0;
	}

	public String getPluginConfigurationFilePath() {
		return cell.getWasHome() + "/config/cells/" + cell.getName() + "/nodes/" + webserver.getNode().getName() + "/servers/" + webserver.getName()
				+ "/plugin-cfg.xml";
	}

}
