/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of Xebialabs Software and Documentation is subject to the Personal
 * License Agreement.
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the Xebialabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.step;

import org.apache.commons.lang.StringUtils;

import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.util.ExtendedStringUtils;

/**
 * Updates the <a href="http://publib.boulder.ibm.com/infocenter/wasinfo/v6r1//index.jsp?topic=/com.ibm.websphere.base.doc/info/aes/ae/tcws_plugin_vhost.html">
 * Virtual Host</a> by adding an alias in a {@link WasCell}
 */
@SuppressWarnings("serial")
public class UpdateWasVirtualHostAliasesStep extends WasStepBase {

	protected static final String UPDATE_VIRTUAL_HOST_ALIASES_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "update-vhost-aliases.py";

	protected String vhostName;

	protected String aliasHostName;

	protected String aliasPortNumber;

	public UpdateWasVirtualHostAliasesStep(WasCell cell, String vhostName, String alias) {
		super(cell);
		this.vhostName = vhostName;
		String[] aliasComponents = StringUtils.split(alias, ':');
		if (aliasComponents == null || aliasComponents.length != 2) {
			throw new ResolutionException("Virtual host definition \"" + alias + "\" is not a valid host specification");
		}
		this.aliasHostName = aliasComponents[0];
		this.aliasPortNumber = aliasComponents[1];
		setDescription("Add alias " + aliasHostName + ":" + aliasPortNumber + " to WAS virtual host " + vhostName + " in cell "
				+ ExtendedStringUtils.getQuotedString(cell.getLabel()));
	}

	public boolean execute(StepExecutionContext ctx) {
		return (executeWsadminJythonScriptResource(ctx, UPDATE_VIRTUAL_HOST_ALIASES_SCRIPT_RESOURCE_PATH, vhostName, aliasPortNumber, aliasHostName) == 0);
	}

	public String getVhostName() {
		return vhostName;
	}

	public String getAliasHostName() {
		return aliasHostName;
	}

	public String getAliasPortNumber() {
		return aliasPortNumber;
	}

}
