#
# Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
#
# Your use of Xebialabs Software and Documentation is subject to the Personal
# License Agreement.
# http://www.xebialabs.com/deployit-personal-edition-license-agreement
# You are granted a personal license (i) to use the Software for your own
# personal purposes which may be used in a production environment and/or (ii)
# to use the Documentation to develop your own plugins to the Software.
# ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
# provided with the Software and/or available on the XebiaLabs website or other
# websites as well as the provided API documentation, tutorial and access to
# the source code of the Xebialabs plugins. You agree not to (i) lease, rent
# or sublicense the Software or Documentation to any third party, or otherwise
# use it except as permitted in this agreement; (ii) reverse engineer,
# decompile, disassemble, or otherwise attempt to determine source code or
# protocols from the Software, and/or to  (iii) copy the Software or
# Documentation (which includes the source code of the XebiaLabs plugins). You
# shall not create or attempt to create any derivative works from the Software
# except and only to the extent permitted by law. You will preserve XebiaLabs'
# copyright and legal notices on the Software and Documentation. XebiaLabs
# retains all rights not expressly granted to You in the Personal License
# Agreement.
#

import sys;

dsName					= sys.argv.pop(0)
providerName            = sys.argv.pop(0)
cellName            = sys.argv.pop(0)
clusterName            = sys.argv.pop(0)

# Look for DataSource with name <dsName> and remove it
datasourceId = AdminConfig.getid('/ServerCluster:' + clusterName + '/JDBCProvider:' + providerName + '/DataSource:' + dsName)
if datasourceId != "":
    print 'Deployit INFO: Destroying JDBC DataSource"' + dsName + '" from cluster scope'
    AdminConfig.remove(datasourceId);
    jaasName = 'cluster_' + clusterName + '_' + dsName + '_user'
else:
    datasourceId = AdminConfig.getid('/Cell:' + cellName + '/JDBCProvider:' + providerName + '/DataSource:' + dsName)
    if datasourceId == "":
        print 'Deployit INFO: Cannot find DataSource "' + dsName + '"'
        sys.exit(1)
    print 'Deployit INFO: Destroying JDBC DataSource"' + dsName + '" from cell scope'
    AdminConfig.remove(datasourceId);
    jaasName = dsName + '_user'


# Look for JAASAuthData with name <jaasName> and remove it
authdatas = AdminConfig.list('JAASAuthData').split();
for authdataId in authdatas:
  n = AdminConfig.showAttribute(authdataId, 'alias');
  if n == jaasName:
    print 'Deployit INFO: Destroying JAAS/J2C authentication data "' + jaasName + '"'
    AdminConfig.remove(authdataId)

# Save configuration
print 'Deployit INFO: Saving configuration'
AdminConfig.save();
