/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.ci;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.mapping.EarMapping;

@SuppressWarnings("serial")
@ConfigurationItem
public class WasEarMapping extends EarMapping {

	@ConfigurationItemProperty(description = "Set of webservers that expose the Eneterprise Application")
	private Set<WasManagedApacheHttpdServer> webservers;
	
	@ConfigurationItemProperty(description = "Specifies the order in which applications are started. Lower values start earlier.")
	private int startingWeight = 1;


	@SuppressWarnings("unchecked")
	public WasEarMapping() {
		// default constructor
		this.webservers = Collections.EMPTY_SET;
	}

	public int getStartingWeight() {
		return startingWeight;
	}
	
	public void setStartingWeight(int startingWeight) {
		this.startingWeight = startingWeight;
	}

	@SuppressWarnings("unchecked")
	public WasEarMapping(Ear source, Serializable target, String virtualHost) {
		this(source, target, (Set<WasManagedApacheHttpdServer>) Collections.EMPTY_SET, virtualHost);
	}

	public WasEarMapping(Ear source, Serializable target, Set<WasManagedApacheHttpdServer> webservers, String virtualHost) {
		super(source, target, virtualHost);
		this.webservers = webservers;
	}

	public Set<WasManagedApacheHttpdServer> getWebservers() {
		return webservers;
	}

	public void setWebservers(Set<WasManagedApacheHttpdServer> webservers) {
		this.webservers = webservers;
	}

}
