/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.mapper;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasEarMapping;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.step.WasDeployApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasStartApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasStopApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasUndeployApplicationStep;

public class EarToWasClusterMapper extends JeeArtifactToWasTargetMapper<Ear, WasEarMapping, WasCluster> {

	public EarToWasClusterMapper(Change<Deployment> change) {
		super(change, true);
	}

	@Override
	protected void generateDeployStep(Ear artifact, WasEarMapping mapping, WasCluster cluster, Collection<WasManagedApacheHttpdServer> webservers, List<Step> steps) {
		// vhost name == artifact's name (see generateAdditionStepsForAddedMapping in JeeArtifactToWasClusterMapper)
		steps.add(new WasDeployApplicationStep(cluster.getCell(), artifact, Collections.singleton(cluster), webservers, artifact.getName(), mapping.getStartingWeight()));
	}
	
	@Override
	protected void generateUndeployStep(Ear artifact, WasCluster cluster, List<Step> steps) {
		steps.add(new WasUndeployApplicationStep(cluster.getCell(), artifact));
	}

	@Override
	protected void generateStartStep(Ear artifact, WasCluster cluster, List<Step> steps) {
		steps.add(new WasStartApplicationStep(cluster, artifact));
	}

	@Override
	protected void generateStopStep(Ear artifact, WasCluster cluster, List<Step> steps) {
		steps.add(new WasStopApplicationStep(cluster, artifact));
	}
	
	@Override
	protected String getVirtualHostFromMapping(WasEarMapping mapping) {
		return mapping.getVirtualHost();
	}
	
	@Override
	public void setDefaults(Deployment d, WasEarMapping m) {
		m.setVirtualHost(d.getVhostDefinition());
	}

}
