/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.mapper;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.mapping.Mapping;
import com.xebialabs.deployit.plugin.was.ci.WasEarMapping;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.ci.WasNode;
import com.xebialabs.deployit.plugin.was.ci.WasTarget;
import com.xebialabs.deployit.plugin.was.ci.WasWarMapping;
import com.xebialabs.deployit.plugin.was.step.CreateWasVirtualHostStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasVirtualHostStep;
import com.xebialabs.deployit.plugin.was.step.SynchronizeWasNodeStep;
import com.xebialabs.deployit.plugin.was.step.UpdateWasVirtualHostAliasesStep;

public abstract class JeeArtifactToWasTargetMapper<S extends NamedDeployableArtifact, M extends Mapping, T extends WasTarget> extends WasStepGeneratingMapper<S, M, T> {

	public JeeArtifactToWasTargetMapper(Change<Deployment> change, boolean applyDefaultMappings) {
		super(change, applyDefaultMappings);
	}

	@Override
	protected final void generateAdditionStepsForAddedMapping(S ear, M mapping, T target, List<Step> steps) {
		Set<WasManagedApacheHttpdServer> webservers;
		if (mapping instanceof WasEarMapping) {
			webservers = ((WasEarMapping) mapping).getWebservers();
		} else if (mapping instanceof WasWarMapping) {
			webservers = ((WasWarMapping) mapping).getWebservers();
		} else {
			webservers = Collections.emptySet();
		}

		steps.add(new CreateWasVirtualHostStep(target.getCell(), ear.getName()));
		steps.add(new UpdateWasVirtualHostAliasesStep(target.getCell(), ear.getName(), getVirtualHostFromMapping(mapping)));
		generateDeployStep(ear, mapping, target, webservers, steps);

		for (WasManagedApacheHttpdServer eachWebServer : webservers) {
			associateVirtualHostWithWebServer(virtualHostsPerWebServer, eachWebServer, getVirtualHostFromMapping(mapping));
		}

		for (WasNode eachNode : target.getNodes()) {
			steps.add(new SynchronizeWasNodeStep(eachNode));
		}

		generateStartStep(ear, target, steps);
	}

	@Override
	protected final void generateDeletionStepsForDeletedMapping(S ear, M mapping, T target, List<Step> steps) {
		Set<WasManagedApacheHttpdServer> webservers;
		if (mapping instanceof WasEarMapping) {
			webservers = ((WasEarMapping) mapping).getWebservers();
		} else if (mapping instanceof WasWarMapping) {
			webservers = ((WasWarMapping) mapping).getWebservers();
		} else {
			webservers = Collections.emptySet();
		}

		generateStopStep(ear, target, steps);
		generateUndeployStep(ear, target, steps);
		steps.add(new DestroyWasVirtualHostStep(target.getCell(), ear.getName()));

		for (WasNode eachNode : target.getNodes()) {
			steps.add(new SynchronizeWasNodeStep(eachNode));
		}

		for (WasManagedApacheHttpdServer eachWebServer : webservers) {
			associateVirtualHostWithWebServer(virtualHostsPerWebServer, eachWebServer, getVirtualHostFromMapping(mapping));
		}
	}

	protected abstract String getVirtualHostFromMapping(M mapping);

	protected abstract void generateDeployStep(S artifact, M mapping, T target, Collection<WasManagedApacheHttpdServer> webservers, List<Step> steps);

	protected abstract void generateUndeployStep(S artifact, T target, List<Step> steps);

	protected abstract void generateStartStep(S artifact, T target, List<Step> steps);

	protected abstract void generateStopStep(S artifact, T target, List<Step> steps);

}
