/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.step;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasServer;
import com.xebialabs.deployit.plugin.was.ci.WasWmqQueueConnectionFactory;
import com.xebialabs.deployit.util.ExtendedStringUtils;

/**
 * Destroys a {@link WasWmqQueueConnectionFactory} in a {@link WasCluster}
 */
@SuppressWarnings("serial")
public class DestroyWasWmqQueueConnectionFactoryStep extends WasStepBase {

	public static String DESTROY_WMS_QCF_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "destroy-wmq-queue-connection-factory.py";

	private WasCluster cluster;
	private WasServer server;

	private WasWmqQueueConnectionFactory qcf;

	public DestroyWasWmqQueueConnectionFactoryStep(WasCluster cluster, WasWmqQueueConnectionFactory qcf) {
		super(cluster.getCell());
		this.cluster = cluster;
		this.server = null;
		this.qcf = qcf;
		setDescription("Destroy WebSphere MQ Queue Connection Factory " + ExtendedStringUtils.getQuotedString(qcf.getLabel()) + " in cluster " + cluster.getLabel());
	}
	
	public DestroyWasWmqQueueConnectionFactoryStep(WasServer server, WasWmqQueueConnectionFactory qcf) {
		super(server.getNode().getCell());
		this.cluster = null;
		this.server = server;
		this.qcf = qcf;
		setDescription("Destroy WebSphere MQ Queue Connection Factory " + ExtendedStringUtils.getQuotedString(qcf.getLabel()) + " in server " + server.getLabel());
	}

	public boolean execute(StepExecutionContext ctx) {
		Map<String, Serializable> context = new HashMap<String, Serializable>();
		if (cluster != null) {
			context.put("cluster", cluster);
		}
		if (server != null) {
			context.put("server", server);
			context.put("node", server.getNode());
			context.put("cell", server.getNode().getCell());
		}
		context.put("qcf", qcf);
		context.put("qcfQueueManagerHost", qcf.getQueueManagerHost());
		int res = executeWsadminJythonScriptResource(ctx, context, DESTROY_WMS_QCF_SCRIPT_RESOURCE_PATH);
		return res == 0;
	}

}
